<p data-nodeid="1425" class="">上一课时，我们提到了 concurrent 下面的 Lock，了解到它可以在 API 级别，对共享资源进行更细粒度的控制。Lock 是基于 AQS（AbstractQueuedSynchronizer）实现的，AQS 是用来构建 Lock 或其他同步组件的基础，它使用了一个 int 成员变量来表示state（同步状态），通过内置的 FIFO 队列，来完成资源获取线程的排队。</p>
<p data-nodeid="1426"><strong data-nodeid="1547">synchronized</strong>的方式加锁，会让线程在 BLOCKED 状态和 RUNNABLE 状态之间切换，在操作系统上，就会造成用户态和内核态的频繁切换，效率就比较低。</p>
<p data-nodeid="1427">与 synchronized 的实现方式不同，<strong data-nodeid="1557">AQS</strong>中很多数据结构的变化，都是依赖 CAS 进行操作的，而<strong data-nodeid="1558">CAS 就是乐观锁的一种实现</strong>。</p>
<h3 data-nodeid="1428">CAS</h3>
<p data-nodeid="1429">CAS 是 Compare And Swap 的缩写，意思是<strong data-nodeid="1565">比较并替换</strong>。</p>
<p data-nodeid="1430">如下图，CAS 机制当中使用了 3 个基本操作数：内存地址V、期望值E、要修改的新值N。更新一个变量的时候，只有当变量的预期值E 和内存地址V 的真正值相同时，才会将内存地址V 对应的值修改为 N。</p>
<p data-nodeid="1431"><img src="https://s0.lgstatic.com/i/image/M00/46/CC/CgqCHl9GGnmABhbVAAB4RWCMsX0107.png" alt="image.png" data-nodeid="1569"></p>
<p data-nodeid="1432">如果本次修改不成功，怎么办？很多情况下，它将一直重试，直到修改为期望的值。</p>
<p data-nodeid="1433">拿 AtomicInteger 类来说，相关的代码如下：</p>
<pre class="lang-java" data-nodeid="1434"><code data-language="java"><span class="hljs-function"><span class="hljs-keyword">public</span> <span class="hljs-keyword">final</span> <span class="hljs-keyword">boolean</span> <span class="hljs-title">compareAndSet</span><span class="hljs-params">(<span class="hljs-keyword">int</span> expectedValue, <span class="hljs-keyword">int</span> newValue)</span> </span>{
 &nbsp; &nbsp; &nbsp; &nbsp;<span class="hljs-keyword">return</span> U.compareAndSetInt(<span class="hljs-keyword">this</span>, VALUE, expectedValue, newValue);
}
</code></pre>
<p data-nodeid="1435"><strong data-nodeid="1575">比较和替换是两个动作，CAS 是如何保证这两个操作的原子性呢？</strong></p>
<p data-nodeid="2500" class="">我们继续向下追踪，发现是 <strong data-nodeid="2506">jdk.internal.misc.Unsafe</strong> 类实现的，循环重试就是在这里发生的：</p>


<pre class="lang-java" data-nodeid="1437"><code data-language="java"><span class="hljs-meta">@HotSpotIntrinsicCandidate</span>
<span class="hljs-function"><span class="hljs-keyword">public</span> <span class="hljs-keyword">final</span> <span class="hljs-keyword">int</span> <span class="hljs-title">getAndAddInt</span><span class="hljs-params">(Object o, <span class="hljs-keyword">long</span> offset, <span class="hljs-keyword">int</span> delta)</span> </span>{
 &nbsp; &nbsp;<span class="hljs-keyword">int</span> v;
 &nbsp; &nbsp;<span class="hljs-keyword">do</span> {
 &nbsp; &nbsp; &nbsp; &nbsp;v = getIntVolatile(o, offset);
 &nbsp;  } <span class="hljs-keyword">while</span> (!weakCompareAndSetInt(o, offset, v, v + delta));
 &nbsp; &nbsp;<span class="hljs-keyword">return</span> v;

}
</code></pre>
<p data-nodeid="1438">追踪到 JVM 内部，在 linux 机器上参照 os_cpu/linux_x86/atomic_linux_x86.hpp。可以看到，最底层的调用，是汇编语言，而最重要的，就是<strong data-nodeid="1598">cmpxchgl</strong>指令。到这里没法再往下找代码了，<strong data-nodeid="1599">因为 CAS 的原子性实际上是硬件 CPU 直接保证的。</strong></p>
<pre class="lang-java" data-nodeid="1439"><code data-language="java">template&lt;&gt;
template&lt;typename T&gt;
inline T Atomic::PlatformCmpxchg&lt;<span class="hljs-number">4</span>&gt;::operator()(T exchange_value,
 &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;T <span class="hljs-keyword">volatile</span>* dest,
 &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;T compare_value,
 &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;atomic_memory_order <span class="hljs-comment">/* order */</span>) <span class="hljs-keyword">const</span> {
 &nbsp;STATIC_ASSERT(<span class="hljs-number">4</span> == sizeof(T));
 &nbsp;<span class="hljs-function">__asm__ <span class="hljs-title">volatile</span> <span class="hljs-params">(<span class="hljs-string">"lock cmpxchgl %1,(%3)"</span>
 &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;  : <span class="hljs-string">"=a"</span> (exchange_value)</span>
 &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;  : "r" <span class="hljs-params">(exchange_value)</span>, "a" <span class="hljs-params">(compare_value)</span>, "r" <span class="hljs-params">(dest)</span>
 &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;  : "cc", "memory")</span>;
 &nbsp;<span class="hljs-keyword">return</span> exchange_value;
}
</code></pre>
<p data-nodeid="3219">那 CAS 实现的原子类，性能能提升多少呢？我们开启了 20 个线程，对共享变量进行自增操作。</p>
<p data-nodeid="3220">从测试结果得知，针对频繁的写操作，原子类的性能是 synchronized 方式的 3 倍。</p>

<p data-nodeid="1441"><img src="https://s0.lgstatic.com/i/image/M00/46/C1/Ciqc1F9GGpOActO6AACqgh2NBj0192.png" alt="chart.png" data-nodeid="1605"></p>
<p data-nodeid="4661"><strong data-nodeid="4666">CAS 原理，在近几年面试中的考察率越来越高，主要是由于乐观锁在读多写少的互联网场景中，使用频率愈发频繁。</strong></p>
<p data-nodeid="4662" class="">你可能发现有一些乐观锁的变种，但最基础的思想是一样的，都是基于<strong data-nodeid="4672">比较替换并替换</strong>的基本操作。</p>


<p data-nodeid="1443">关于 Atomic 类，还有一个小细节，那就是它的主要变量，使用了 volatile 关键字进行修饰。代码如下，你知道它是用来干什么的吗？</p>
<pre class="lang-java" data-nodeid="1444"><code data-language="java"><span class="hljs-keyword">private</span> <span class="hljs-keyword">volatile</span> <span class="hljs-keyword">int</span> value;
</code></pre>
<p data-nodeid="1445">答案：使用了 volatile 关键字的变量，每当变量的值有变动的时候，都会将更改立即同步到主内存中；而如果某个线程想要使用这个变量，就先要从主存中刷新到工作内存，这样就确保了变量的可见性。有了这个关键字的修饰，就能保证每次比较的时候，拿到的值总是最新的。</p>
<h3 data-nodeid="1446">乐观锁</h3>
<p data-nodeid="13913" class="">从上面的描述可以看出，<strong data-nodeid="13919">乐观锁</strong>严格来说，并不是一种锁，它提供了一种检测冲突的机制，并在有冲突的时候，采取重试的方法完成某项操作。假如没有重试操作，乐观锁就仅仅是一个判断逻辑而已。</p>













<p data-nodeid="1448">从这里可以看出乐观锁与悲观锁的一些区别。悲观锁每次操作数据的时候，都会认为别人会修改，所以每次在操作数据的时候，都会加锁，除非别人释放掉锁。</p>
<p data-nodeid="1449">乐观锁在检测到冲突的时候，会有多次重试操作，所以之前我们说，乐观锁适合用在读多写少的场景；而在资源冲突比较严重的场景，乐观锁会出现多次失败的情况，造成 CPU 的空转，所以悲观锁在这种场景下，会有更好的性能。</p>
<p data-nodeid="1450"><strong data-nodeid="1631">为什么读多写少的情况，就适合使用乐观锁呢？悲观锁在读多写少的情况下，不也是有很少的冲突吗？</strong></p>
<p data-nodeid="1451">其实，问题不在于冲突的频繁性，而在于<strong data-nodeid="1637">加锁这个动作</strong>上。</p>
<ul data-nodeid="1452">
<li data-nodeid="1453">
<p data-nodeid="1454">悲观锁需要遵循下面三种模式：一锁、二读、三更新，即使在没有冲突的情况下，执行也会非常慢；</p>
</li>
<li data-nodeid="1455">
<p data-nodeid="1456">如之前所说，乐观锁本质上不是锁，它只是一个判断逻辑，资源冲突少的情况下，它不会产生任何开销。</p>
</li>
</ul>
<p data-nodeid="1457">我们上面谈的 CAS 操作，就是一种典型的乐观锁实现方式，我们顺便看一下 CAS 的缺点，也就是乐观锁的一些缺点。</p>
<ul data-nodeid="1458">
<li data-nodeid="1459">
<p data-nodeid="1460">在并发量比较高的情况下，有些线程可能会一直尝试修改某个资源，但由于冲突比较严重，一直更新不成功，这时候，就会给 CPU 带来很大的压力。JDK 1.8 中新增的 LongAdder，通过把原值进行拆分，最后再以 sum 的方式，减少 CAS 操作冲突的概率，性能要比 AtomicLong 高出 10 倍左右。</p>
</li>
<li data-nodeid="1461">
<p data-nodeid="1462">CAS 操作的对象，只能是单个资源，如果想要保证多个资源的原子性，最好使用synchronized 等经典加锁方式</p>
</li>
<li data-nodeid="1463">
<p data-nodeid="1464">ABA 问题，意思是指在 CAS 操作时，有其他的线程现将变量的值由 A 变成了 B，然后又改成了 A，当前线程在操作时，发现值仍然是 A，于是进行了交换操作。这种情况在某些场景下可不用过度关注，比如 AtomicInteger，因为没什么影响；但在一些其他操作，比如链表中，会出现问题，必须要避免。可以使用 AtomicStampedReference 给引用标记上一个整型的版本戳，来保证原子性。</p>
</li>
</ul>
<h3 data-nodeid="1465">乐观锁实现余额更新</h3>
<p data-nodeid="1466">对余额的操作，是交易系统里最常见的操作了。先读出余额的值，进行一番修改之后，再写回这个值。</p>
<p data-nodeid="1467">对余额的任何更新，都需要进行加锁。因为读取和写入操作并不是原子性的，如果同一时刻发生了多次与余额的操作，就会产生不一致的情况。</p>
<p data-nodeid="1468">举一个比较明显的例子。你同时发起了一笔消费 80 元和 5 元的请求，经过操作之后，两个支付都成功了，但最后余额却只减了 5 元。相当于花了 5 块钱买了 85 元的东西。请看下面的时序：</p>
<pre class="lang-java" data-nodeid="1469"><code data-language="java">请求A：读取余额<span class="hljs-number">100</span>
请求B：读取余额<span class="hljs-number">100</span>
请求A：花掉<span class="hljs-number">5</span>元，临时余额是<span class="hljs-number">95</span>
请求B：花掉<span class="hljs-number">80</span>元，临时余额是<span class="hljs-number">20</span>
请求B：写入余额<span class="hljs-number">20</span>成功
请求A：写入余额<span class="hljs-number">95</span>成功
</code></pre>
<p data-nodeid="15346" class="">我曾经在线上遇到过一个 P0 级别的 BUG，用户通过构造请求，频繁发起 100 元的提现和 1 分钱的提现，造成了比较严重的后果，你可以自行分析一下这个过程。</p>


<p data-nodeid="1471"><strong data-nodeid="1653">所以，对余额操作加锁，是必须的。</strong> 这个过程和多线程的操作是类似的，不过多线程是单机的，而余额的场景是分布式的。</p>
<p data-nodeid="16774" class="">对于数据库来说，就可以通过加行锁进行解决，拿 MySQL 来说，MyISAM 是不支持行锁的，我们只能使用 InnoDB，典型的 SQL 语句如下：</p>


<pre class="lang-java" data-nodeid="1473"><code data-language="java">select * from user where userid={id} <span class="hljs-keyword">for</span> update
</code></pre>
<p data-nodeid="1474">使用 select for update 这么一句简单的 SQL，其实在底层就加了三把锁，非常昂贵。</p>
<blockquote data-nodeid="18926">
<p data-nodeid="18927" class="">默认对主键索引加锁，不过这里直接忽略；<br>
二级索引 userid={id} 的 next key lock（记录+间隙锁）；<br>
二级索引 userid={id} 的下一条记录的间隙锁。</p>
</blockquote>



<p data-nodeid="1477">所以，在现实场景中，这种悲观锁都已经不再采用，第一是因为它不够通用，第二是因为它非常昂贵。</p>
<p data-nodeid="1478">一种比较好的办法，就是使用乐观锁。根据上面我们对于乐观锁的定义，就可以抽象两个概念：</p>
<ul data-nodeid="1479">
<li data-nodeid="1480">
<p data-nodeid="1481"><strong data-nodeid="1667">检测冲突的机制</strong>：先查出本次操作的余额E，在更新时判断是否与当前数据库的值相同，如果相同则执行更新动作</p>
</li>
<li data-nodeid="1482">
<p data-nodeid="1483"><strong data-nodeid="1672">重试策略</strong>：有冲突直接失败，或者重试5次后失败</p>
</li>
</ul>
<p data-nodeid="1484">伪代码如下，可以看到这其实就是 CAS。</p>
<pre class="lang-dart" data-nodeid="1485"><code data-language="dart"># old_balance获取
select balance from  user where userid={id}
# 更新动作 
update user <span class="hljs-keyword">set</span> balance = balance - <span class="hljs-number">20</span>
 &nbsp; &nbsp;where userid={id} 
 &nbsp; &nbsp;and balance &gt;= <span class="hljs-number">20</span>
 &nbsp; &nbsp;and balance = $old_balance
</code></pre>
<p data-nodeid="1486">还有一种 CAS 的变种，就是使用版本号机制。通过在表中加一个额外的字段 version，来代替对余额的判断。这种方式不用去关注具体的业务逻辑，可控制多个变量的更新，可扩展性更强，典型的伪代码如下：</p>
<pre class="lang-yaml" data-nodeid="1487"><code data-language="yaml"><span class="hljs-string">version,balance</span> <span class="hljs-string">=</span> <span class="hljs-string">dao.getBalance(userid)</span>
<span class="hljs-string">balance</span> <span class="hljs-string">=</span> <span class="hljs-string">balance</span> <span class="hljs-bullet">-</span> <span class="hljs-string">cost</span>
<span class="hljs-string">dao.exec("</span>
 &nbsp; &nbsp;<span class="hljs-string">update</span> <span class="hljs-string">user</span> 
 &nbsp; &nbsp;<span class="hljs-string">set</span> <span class="hljs-string">balance</span> <span class="hljs-string">=</span> <span class="hljs-string">balance</span> <span class="hljs-bullet">-</span> <span class="hljs-number">20</span>
 &nbsp; &nbsp;<span class="hljs-string">version</span> <span class="hljs-string">=</span> <span class="hljs-string">version</span> <span class="hljs-string">+</span> <span class="hljs-number">1</span>
 &nbsp; &nbsp;<span class="hljs-string">where</span> <span class="hljs-string">userid=id</span> 
 &nbsp; &nbsp;<span class="hljs-string">and</span> <span class="hljs-string">balance</span> <span class="hljs-string">&gt;=</span> <span class="hljs-number">20</span>
 &nbsp; &nbsp;<span class="hljs-string">and</span> <span class="hljs-string">version</span> <span class="hljs-string">=</span> <span class="hljs-string">$old_version</span>
<span class="hljs-string">")
</span></code></pre>
<h3 data-nodeid="1488">Redis 分布式锁</h3>
<p data-nodeid="1489">Redis 的分布式锁，是互联网行业经常使用的方案。很多同学知道是使用 setnx 或者带参数的 set 方法来实现的，但 Redis 的分布式锁其实有很多坑。</p>
<p data-nodeid="23947">在“08 | 案例分析：Redis 如何助力秒杀业务”中，我们演示了一个使用 lua 脚本来实现秒杀场景。但在现实情况中，秒杀业务通常不会这么简单，它需要在查询和用户扣减操作之间，执行一些其他业务。</p>
<p data-nodeid="23948" class="">比如，进行一些商品校验、订单生成等，这个时候，使用分布式锁，可以实现更灵活地控制，它主要依赖 SETNX 指令或者带参数的 SET 指令。</p>







<ul data-nodeid="1491">
<li data-nodeid="1492">
<p data-nodeid="1493">锁创建：SETNX [KEY] [VALUE] 原子操作，意思是在指定的 KEY 不存在的时候，创建一个并返回 1，否则返回 0。我们通常使用参数更全的 set key value [EX seconds] [PX milliseconds] [NX|XX] 命令，同时对 KEY 设置一个超时时间。</p>
</li>
<li data-nodeid="1494">
<p data-nodeid="1495">锁查询：GET KEY，通过简单地判断 KEY 是否存在即可</p>
</li>
<li data-nodeid="1496">
<p data-nodeid="1497">锁删除：DEL KEY，删掉相应的 KEY 即可</p>
</li>
</ul>
<p data-nodeid="1498">根据原生的语义，我们有下面简单的 lock 和 unlock 方法，lock 方法通过不断的重试，来获取到分布式锁，然后通过删除命令销毁分布式锁。</p>
<pre class="lang-java" data-nodeid="1499"><code data-language="java"><span class="hljs-function"><span class="hljs-keyword">public</span> <span class="hljs-keyword">void</span> <span class="hljs-title">lock</span><span class="hljs-params">(String key, <span class="hljs-keyword">int</span> timeOutSecond)</span> </span>{
 &nbsp; &nbsp;<span class="hljs-keyword">for</span> (; ; ) {
 &nbsp; &nbsp; &nbsp; &nbsp;<span class="hljs-keyword">boolean</span> exist = redisTemplate.opsForValue().setIfAbsent(key, <span class="hljs-string">""</span>, timeOutSecond, TimeUnit.SECONDS);
 &nbsp; &nbsp; &nbsp; &nbsp;<span class="hljs-keyword">if</span> (exist) {
 &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;<span class="hljs-keyword">break</span>;
 &nbsp; &nbsp; &nbsp;  }
 &nbsp;  }
}
<span class="hljs-function"><span class="hljs-keyword">public</span> <span class="hljs-keyword">void</span> <span class="hljs-title">unlock</span><span class="hljs-params">(String key)</span> </span>{
 &nbsp; &nbsp;redisTemplate.delete(key);
}
</code></pre>
<p data-nodeid="1500">这段代码中的问题很多，我们只指出其中一个最严重的问题。在多线程中，执行 unlock方法的，只能是当前的线程，但在上面的实现中，由于超时存在的原因，锁被提前释放了。考虑下面 3 个请求的时序：</p>
<ul data-nodeid="1501">
<li data-nodeid="1502">
<p data-nodeid="1503"><strong data-nodeid="1711">请求A：</strong> 获取了资源 x 的锁，锁的超时时间为 5 秒</p>
</li>
<li data-nodeid="1504">
<p data-nodeid="1505"><strong data-nodeid="1716">请求A：</strong> 由于业务执行时间比较长，业务阻塞等待，超过 5 秒</p>
</li>
<li data-nodeid="1506">
<p data-nodeid="1507"><strong data-nodeid="1721">请求B：</strong> 第 6 秒发起请求，结果发现锁 x 已经失效，于是顺利获得锁</p>
</li>
<li data-nodeid="1508">
<p data-nodeid="1509"><strong data-nodeid="1726">请求A：</strong> 第 7 秒，请求 A 执行完毕，然后执行锁释放动作</p>
</li>
<li data-nodeid="1510">
<p data-nodeid="1511"><strong data-nodeid="1731">请求C：</strong> 请求 C 在锁刚释放的时候发起了请求，结果顺利拿到了锁资源</p>
</li>
</ul>
<p data-nodeid="1512">此时，请求 B 和请求 C 都成功地获取了锁 x，我们的分布式锁失效了，在执行业务逻辑的时候，就容易发生问题。</p>
<p data-nodeid="1513">所以，在删除锁的时候，需要判断它的请求方是否正确。首先，获取锁中的当前标识，然后，在删除的时候，判断这个标识是否和解锁请求中的相同。</p>
<p data-nodeid="1514">可以看到，读取和判断是两个不同的操作，在这两个操作之间同样会有间隙，高并发下会出现执行错乱问题，而稳妥的方案，是使用 lua 脚本把它们封装成原子操作。</p>
<p data-nodeid="1515">改造后的代码如下：</p>
<pre class="lang-java" data-nodeid="1516"><code data-language="java"><span class="hljs-function"><span class="hljs-keyword">public</span> String <span class="hljs-title">lock</span><span class="hljs-params">(String key, <span class="hljs-keyword">int</span> timeOutSecond)</span> </span>{
 &nbsp; &nbsp;<span class="hljs-keyword">for</span> (; ; ) {
 &nbsp; &nbsp; &nbsp; &nbsp;String stamp = String.valueOf(System.nanoTime());
 &nbsp; &nbsp; &nbsp; &nbsp;<span class="hljs-keyword">boolean</span> exist = redisTemplate.opsForValue().setIfAbsent(key, stamp, timeOutSecond, TimeUnit.SECONDS);
 &nbsp; &nbsp; &nbsp; &nbsp;<span class="hljs-keyword">if</span> (exist) {
 &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;<span class="hljs-keyword">return</span> stamp;
 &nbsp; &nbsp; &nbsp;  }
 &nbsp;  }
}
<span class="hljs-function"><span class="hljs-keyword">public</span> <span class="hljs-keyword">void</span> <span class="hljs-title">unlock</span><span class="hljs-params">(String key, String stamp)</span> </span>{
 &nbsp; &nbsp;redisTemplate.execute(script, Arrays.asList(key), stamp);
}
</code></pre>
<p data-nodeid="1517">相应的 lua 脚本如下：</p>
<pre class="lang-java" data-nodeid="1518"><code data-language="java">local stamp = ARGV[<span class="hljs-number">1</span>]
local key = KEYS[<span class="hljs-number">1</span>]
local current = redis.call(<span class="hljs-string">"GET"</span>,key)
<span class="hljs-keyword">if</span> stamp == current then
 &nbsp; &nbsp;redis.call(<span class="hljs-string">"DEL"</span>,key)
 &nbsp; &nbsp;<span class="hljs-keyword">return</span> <span class="hljs-string">"OK"</span>
end
</code></pre>
<p data-nodeid="25397">可以看到，reids 实现分布式锁，还是有一定难度的。推荐使用 redlock 的 Java 客户端实现 redisson，它是根据 <a href="https://redis.io/topics/distlock" data-nodeid="25402">Redis 官方</a>提出的分布式锁管理方法实现的。</p>
<p data-nodeid="25398" class="">这个锁的算法，处理了分布式锁在多 redis 实例场景下，以及一些异常情况的问题，有更高的容错性。比如，我们前面提到的锁超时问题，在 redisson 会通过看门狗机制对锁进行无限续期，来保证业务的正常运行。</p>


<p data-nodeid="1520">我们可以看下 redisson 分布式锁的典型使用代码。</p>
<pre class="lang-java" data-nodeid="1521"><code data-language="java">String resourceKey = <span class="hljs-string">"goodgirl"</span>;
RLock lock = redisson.getLock(resourceKey);
<span class="hljs-keyword">try</span> {
&nbsp; &nbsp; lock.lock(<span class="hljs-number">5</span>, TimeUnit.SECONDS);
&nbsp; &nbsp; <span class="hljs-comment">//真正的业务</span>
&nbsp; &nbsp; Thread.sleep(<span class="hljs-number">100</span>);
} <span class="hljs-keyword">catch</span> (Exception ex) {
&nbsp; &nbsp; ex.printStackTrace();
} <span class="hljs-keyword">finally</span> {
&nbsp; &nbsp; <span class="hljs-keyword">if</span> (lock.isLocked()) {
&nbsp; &nbsp; &nbsp; &nbsp; lock.unlock();
&nbsp; &nbsp; }
}
</code></pre>
<p data-nodeid="1522">使用 redis 的 monitor 命令，可以看到具体的执行步骤，这个过程还是比较复杂的。</p>
<p data-nodeid="1523"><img src="https://s0.lgstatic.com/i/image/M00/46/CC/CgqCHl9GGvuAY0otAAKk-rNnRjQ444.jpg" alt="15963703738863.jpg" data-nodeid="1746"></p>
<h3 data-nodeid="1524">无锁</h3>
<p data-nodeid="1525">无锁（Lock-Free），指的是在多线程环境下，在访问共享资源的时候，不会阻塞其他线程的执行。</p>
<p data-nodeid="26853">在 Java 中，最典型的无锁队列实现，就是 ConcurrentLinkedQueue，但它是无界的，不能够指定它的大小。ConcurrentLinkedQueue 使用 CAS 来处理对数据的并发访问，这是无锁算法得以实现的基础。</p>
<p data-nodeid="26854" class="">CAS 指令不会引起上下文切换和线程调度，是非常轻量级的多线程同步机制。它还把入队、出队等对 head 和 tail 节点的一些原子操作，拆分出更细的步骤，进一步缩小了 CAS 控制的范围。</p>


<p data-nodeid="1527">ConcurrentLinkedQueue 是一个非阻塞队列，性能很高，但不是很常用。千万不要和阻塞队列 LinkedBlockingQueue（内部基于锁）搞混了。</p>
<p data-nodeid="28313">Disruptor 是一个无锁、有界的队列框架，它的性能非常高。它使用 RingBuffer、无锁和缓存行填充等技术，追求性能的极致，在极高并发的场景，可以使用它替换传统的 BlockingQueue。</p>
<p data-nodeid="28314" class="">在一些中间件中经常被使用，比如日志、消息等（Storm 使用它实现进程内部通信机制），但它在业务系统上很少用，除非是类似秒杀的场景。因为它的编程模型比较复杂，而且业务的主要瓶颈主要在于缓慢的 I/O 上，而不是慢在队列上。</p>


<h3 data-nodeid="1529">小结</h3>
<p data-nodeid="1530">本课时，我们从 CAS 出发，逐步了解了乐观锁的一些概念和使用场景。</p>
<p data-nodeid="1531"><strong data-nodeid="1758">乐观锁</strong>严格来说，并不是一种锁。它提供了一种检测冲突的机制，并在有冲突的时候，采取重试的方法完成某项操作。假如没有重试操作，乐观锁就仅仅是一个判断逻辑而已。</p>
<p data-nodeid="1532"><strong data-nodeid="1763">悲观锁</strong>每次操作数据的时候，都会认为别人会修改，所以每次在操作数据的时候，都会加锁，除非别人释放掉锁。</p>
<p data-nodeid="1533">乐观锁在读多写少的情况下，之所以比悲观锁快，是因为悲观锁需要进行很多额外的操作，并且乐观锁在没有冲突的情况下，也根本不耗费资源。但乐观锁在冲突比较严重的情况下，由于不断地重试，其性能在大多数情况下，是不如悲观锁的。</p>
<p data-nodeid="1534">由于乐观锁的这个特性，乐观锁在读多写少的互联网环境中被广泛应用。</p>
<p data-nodeid="1535">本课时，我们主要看了在数据库层面的一个乐观锁实现，以及<strong data-nodeid="1771">Redis 分布式锁</strong>的实现，后者在实现的时候，还是有很多细节需要注意的，建议使用 redisson 的 RLock。</p>
<p data-nodeid="1536">当然，乐观锁有它的使用场景。当冲突非常严重的情况下，会进行大量的无效计算；它也只能保护单一的资源，处理多个资源的情况下就捉襟见肘；它还会有 ABA 问题，使用带版本号的乐观锁变种可以解决这个问题。</p>
<p data-nodeid="1537">这些经验，我们都可以从 CAS 中进行借鉴。多线程环境和分布式环境有很多相似之处，对于乐观锁来说，我们找到一种检测冲突的机制，就基本上实现了。</p>
<p data-nodeid="1538"><strong data-nodeid="1777">下面留一个问题，请你分析解答：</strong></p>
<p data-nodeid="1539">一个接口的写操作，大约会花费 5 分钟左右的时间。它在开始写时，会把数据库里的一个字段值更新为 start，写入完成后，更新为 done。有另外一个用户也想写入一些数据，但需要等待状态为 done。</p>
<p data-nodeid="1540">于是，开发人员在 WEB 端，使用轮询，每隔 5 秒，查询字段值是否为 done，当查询到正确的值，即可开始进行数据写入。</p>
<p data-nodeid="1541" class="">开发人员的这个方法，属于乐观锁吗？有哪些潜在问题？应该如何避免？欢迎你在下方留言区作答，我将一一解答，与你讨论。</p>

---

### 精选评论

##### *波：
> 李师傅，能提示下为什么ConcurrentLinkedQueue不是很常用么？按理来说无锁的非阻塞队列不是比阻塞队列性能更高么？

 ###### &nbsp;&nbsp;&nbsp; 讲师回复：
> &nbsp;&nbsp;&nbsp; 1. 它是无界的，不好控制大小，容易内存过度使用
2. 里面很多API使用起来不友好，比如里面的size()方法，竟然是for循环，容易有性能问题
3. api不丰富，比如没有阻塞的tak和put方法

##### *飞：
> 属于乐观锁。但是写操作没有做 成原子操作，多线程下会造成 数据不准确。可以在写的时候利用CAS去操作(java或者数据库层面的都可以)，另外轮训时间应该根据业务进行压测，去取平均时间。

##### **武：
> disrupt我们公司现在还在用

 ###### &nbsp;&nbsp;&nbsp; 讲师回复：
> &nbsp;&nbsp;&nbsp; disruptor还是很不错的，非常高的并发下优化效果明显

##### **6905：
> 是乐观锁 也是多请求 获取资源 问题应该是5s一次 但是写要5分钟 这个不太合理 然后如果程序崩溃了 数据库锁释放不了 没有设置超时时间 或者可重入

 ###### &nbsp;&nbsp;&nbsp; 讲师回复：
> &nbsp;&nbsp;&nbsp; 非常好，理解的很透彻

##### **哈：
> 属于乐观锁，但是更新start的时候没有版本的控制

##### **辉：
> 乐观锁每次都要判断版本是不是不就增加了，代码复杂度么老师

 ###### &nbsp;&nbsp;&nbsp; 讲师回复：
> &nbsp;&nbsp;&nbsp; 不复杂，甚至在sql就可以完成。可以参考下面示例代码：version,balance = dao.getBalance(userid)
balance = balance - cost
dao.exec("
    update user 
    set balance = balance - 20
    version = version + 1
    where userid=id 
    and balance >= 20
    and version = $old_version
")

##### **平：
> 这个属于乐观锁 潜在的问题是如果查询到done到开始写入之间有其他写入也进行了执行那就出现不一致了 根本问题是查询和写入不是一个原子操作 解决办法通过数据库或者redis实现状态位更新做控制 类似cas如果能成功即可写入

 ###### &nbsp;&nbsp;&nbsp; 讲师回复：
> &nbsp;&nbsp;&nbsp; 学以致用，加油！

##### **春：
> 冲突检测机制才是乐观锁，只是等待及轮询状态，应该不是乐观锁

 ###### &nbsp;&nbsp;&nbsp; 讲师回复：
> &nbsp;&nbsp;&nbsp; 这个应该属于乐观锁范畴的，这条记录的done状态，就是争抢资源；5秒钟尝试状态，就是tryLock的操作。只不过这种方式不太完善，可以在tryLock成功的时候，把获取到资源的ID也记录一下。另外，5分钟只是预估的，需要设置一个合理的超时时间。

##### **积极备考架构：
> 不属于，一般乐观锁是在那条记录上加一个version，比较更新。这样写入失败的时候可能造成死锁，前端不断轮询也比较占用资源。

 ###### &nbsp;&nbsp;&nbsp; 讲师回复：
> &nbsp;&nbsp;&nbsp; 你的这个思路，已经向乐观锁方向进发了。这里主要的问题是轮询间隔内可能有其他的请求获取了done状态。所有由done到begin这个状态应该是原子的，或者使用额外的字段记录获取到锁的调用方

##### **波：
> 属于乐观锁缺陷：1如果程序处理发生异常，导致释放锁的动作没有成功，将会导致一直循环处理方式：1也可以给锁设置超时时间

 ###### &nbsp;&nbsp;&nbsp; 讲师回复：
> &nbsp;&nbsp;&nbsp; 还有一个缺陷，那就是在5秒中的间隔时间内，可能有其他的请求进入，同样判断成功，造成两个请求并行。可以通过加入执行者标志的方式去避免。

